/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.content;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.content.IVWContentViewMouseListener;
import filenet.vw.toolkit.admin.content.VWConfigContentViewMouseAndKeyListener;
import filenet.vw.toolkit.admin.content.VWConfigContentViewPane;
import filenet.vw.toolkit.admin.content.VWConfigIcon;
import filenet.vw.toolkit.admin.content.VWConfigIconFocusAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

class VWConfigIconViewPane
extends JPanel
implements IVWContentViewMouseListener {
    private VWConfigContentViewMouseAndKeyListener m_contentViewMouseAdapter = null;
    private ActionListener m_actionListener = null;
    private VWConfigIcon[] m_icons = new VWConfigIcon[1];

    public VWConfigIconViewPane(VWConfigContentViewPane contentPane, VWConfigBaseNode node, ActionListener listener) {
        try {
            this.setLayout(new FlowLayout(3));
            this.setBackground(SystemColor.text);
            Dimension dim = VWStringUtils.stringToDimension("665,385");
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setPreferredSize(dim);
            this.m_contentViewMouseAdapter = new VWConfigContentViewMouseAndKeyListener(contentPane, this, node.getSessionInfo());
            this.m_actionListener = listener;
            this.addMouseListener(this.m_contentViewMouseAdapter);
            this.displayContent(node);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayContent(VWConfigBaseNode node) {
        int i;
        if (this.m_icons[0] != null) {
            this.m_icons[0].requestFocus();
            this.m_icons[0].requestFocusInWindow();
        }
        this.updateUI();
        int childCount = node.getChildCount();
        if (this.m_icons.length < childCount) {
            int i2;
            VWConfigIcon[] icons = new VWConfigIcon[childCount];
            for (i2 = 0; i2 < this.m_icons.length; ++i2) {
                icons[i2] = this.m_icons[i2];
            }
            for (i2 = this.m_icons.length; i2 < childCount; ++i2) {
                icons[i2] = null;
            }
            this.m_icons = icons;
            icons = null;
        }
        for (i = 0; i < childCount; ++i) {
            VWConfigBaseNode obj = (VWConfigBaseNode)node.getChildAt(i);
            VWConfigIcon icon = this.makeButton(this.m_icons[i], obj, 0, 3);
            if (this.m_icons[i] == null) {
                this.add(icon);
                this.m_icons[i] = icon;
            }
            this.m_icons[i].setVisible(true);
        }
        for (i = childCount; i < this.m_icons.length; ++i) {
            this.m_icons[i].setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.updateUI();
        if (this.m_icons[0] != null && this.m_icons[0].isVisible()) {
            this.m_icons[0].requestFocusInWindow();
            this.m_icons[0].requestFocus();
        }
    }

    public void requestIconFocus(VWConfigIcon anIcon) {
        JComponent icon = null;
        int count = this.getComponentCount();
        boolean bFocusRequested = false;
        for (int i = 0; i < count; ++i) {
            Component obj = this.getComponent(i);
            if (obj == null || !(obj instanceof VWConfigIcon)) continue;
            if (obj == anIcon) {
                anIcon.requestFocus();
                bFocusRequested = true;
                break;
            }
            if (icon != null) continue;
            icon = (VWConfigIcon)obj;
        }
        if (!bFocusRequested && icon != null) {
            icon.requestFocus();
        }
    }

    protected void releaseResources() {
        if (this.m_contentViewMouseAdapter != null) {
            this.m_contentViewMouseAdapter.releaseResources();
            this.m_contentViewMouseAdapter = null;
        }
        this.m_actionListener = null;
    }

    private VWConfigIcon makeButton(VWConfigBaseNode node, int hPosition, int vPosition) {
        VWConfigIcon b = new VWConfigIcon(node);
        b.setHorizontalTextPosition(hPosition);
        b.setVerticalTextPosition(vPosition);
        b.setToolTipText(node.getActionCommandString());
        b.setActionCommand(node.getActionCommandString());
        b.addMouseListener(this.m_contentViewMouseAdapter);
        b.addKeyListener(this.m_contentViewMouseAdapter);
        b.setBorder(new LineBorder(SystemColor.windowBorder));
        b.setFocusPainted(false);
        b.addActionListener(this.m_actionListener);
        b.addFocusListener(new VWConfigIconFocusAdapter(b));
        return b;
    }

    private VWConfigIcon makeButton(VWConfigIcon b, VWConfigBaseNode node, int hPosition, int vPosition) {
        if (b == null) {
            b = new VWConfigIcon(node);
            b.setBorder(new LineBorder(SystemColor.windowBorder));
            b.setFocusPainted(false);
            b.addActionListener(this.m_actionListener);
            b.addFocusListener(new VWConfigIconFocusAdapter(b));
            b.addMouseListener(this.m_contentViewMouseAdapter);
            b.addKeyListener(this.m_contentViewMouseAdapter);
        } else {
            b.m_node = node;
            b.setText(node.getName());
            b.setIcon(node.getIcon32());
        }
        b.setHorizontalTextPosition(hPosition);
        b.setVerticalTextPosition(vPosition);
        b.setToolTipText(node.getActionCommandString());
        b.setActionCommand(node.getActionCommandString());
        return b;
    }
}

